function PositionSoundMachine(){
this.soundclasses = [];
this.radius=400;

this.addSoundPos = function (soundname,position){
	
	for(var i=0;i<this.soundclasses.length;i++){
			
		if(this.soundclasses[i].name==soundname){
			return new Array(i,this.soundclasses[i].addPosition(position));
			}
			
		}
		this.soundclasses.push(new SoundClass(soundname,position));
		return new Array(this.soundclasses.length-1,0);
	}
	

	
this.changeSoundPos = function(arr,x,y){
	this.soundclasses[arr[0]].positions[arr[1]].x=x;
	this.soundclasses[arr[0]].positions[arr[1]].y=y;
	GarbageCollect();

	}
this.delSoundClass = function(soundname){
		var tmparr=[];
		for(var i=0;i<this.soundclasses.length;i++){
			if(this.soundclasses[i].name!=soundname){
				tmparr.push(this.soundclasses[i]);
				}
			else{
				this.soundclasses[i].sound.stop();
				}
			}	
		delete this.soundclasses;
		GarbageCollect();
		this.soundclasses=tmparr;
		}


this.computeVolumes = function(max){
	for(var i=0;i<this.soundclasses.length;i++){
	
		this.soundclasses[i].computeVolume(this.radius,max);
	
		}
	}
}


function SoundClass(soundname,position){
	this.name=soundname;
	this.sound=LoadSound(soundname,false);
	this.positions = [position];
	this.volume=0;
	this.addPosition = function (position){
	
		this.positions.push(position);
		return this.positions.length-1;
	}
	
	this.computeVolume = function(radius,max){
		this.volume=0;
		if(IsMapEngineRunning()){
		
			for(var i=0;i<this.positions.length;i++){
			
				var tmpvolume=radius-Math.sqrt(Math.pow(GetCameraX()-this.positions[i].x,2)+Math.pow(GetCameraY()-this.positions[i].y,2));
				if(tmpvolume<0)tmpvolume=0;
				tmpvolume/=radius;
				tmpvolume*=max;
				if (tmpvolume>this.volume)this.volume=tmpvolume;
			}
			
		}
		this.sound.setVolume(this.volume);
		if(!this.sound.isPlaying())this.sound.play(true);
	}

}